#version 460

uniform sampler2D right, left, top, bottom, front,back;

in vec3 n;
in vec3 incident;

out vec4 color;

void main() {

    vec3 nn = normalize(n);
    vec3 i = normalize(incident);

    vec3 refl = reflect(i, nn);

    vec3 absRefl = abs(refl);

    float k = max(absRefl.x, max(absRefl.y, absRefl.z));

    if (k == absRefl.x) {
        refl = refl /absRefl.x;
        if (refl.x > 0)
            color = texture(right, vec2(-refl.z, refl.y) * 0.5 + 0.5);
        else 
            color = texture(left, vec2(refl.z, refl.y) * 0.5 + 0.5);
    }
    else if (k == absRefl.z) {
        refl = refl /absRefl.z;
        if (refl.z > 0)
            color = texture(front, vec2(refl.x, refl.y) * 0.5 + 0.5);
        else 
            color = texture(back, vec2(-refl.x, refl.y) * 0.5 + 0.5);
    }
    else  {
        refl = refl /absRefl.y;
        if (refl.y > 0)
            color = texture(top, vec2(refl.x, -refl.z) * 0.5 + 0.5);
        else 
            color = texture(bottom, vec2(refl.x, refl.z) * 0.5 + 0.5);
    }
}
